int analogPin = 0;
int analogVal=-1;

int sampleIdx = 0;
unsigned char samples[16] = {};

void setup(){
  analogReference(EXTERNAL);
  Serial.begin(9600);
}

void addSample(unsigned char sample){
    if (samples[sampleIdx] == sample) return;
    sampleIdx = (sampleIdx + 1) & 15;
    samples[sampleIdx] = sample;
}

int averageSignal()
{
  int sum = 0;
  int i;
  for (i = 0; i < 16; i++)
  {
    sum += samples[i];
  }
  return sum / 16;
}

void loop(){
  analogVal = analogRead(analogPin) >> 2;
  addSample(analogVal);
  Serial.println(averageSignal());
}

